#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// tiled noise texturesMod01.fsh  by   shiyuugo  
//https://www.shadertoy.com/view/Dl2Gzz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define RANDOM_COLOR
#define AUTO_LIGHT
/*--------------------------------------------------
 # glslUtils
 - https://gist.github.com/patriciogonzalezvivo/670c22f3966e662d2f83
 - https://github.com/ashima/webgl-noise
 - https://thebookofshaders.com/
 - 
--------------------------------------------------*/

float random(float n){return fract(sin(n) * 43758.5453123);}
float random(vec2 st) {return fract(sin(dot(st.xy, vec2(12.9898, 78.233))) * 43758.5453123);}
float noise(float p){
	float fl = floor(p), fc = fract(p);
	return mix(random(fl), random(fl + 1.0), fc);
}
float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
  vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(random(b), random(b + d.yx), f.x), mix(random(b + d.xy), random(b + d.yy), f.x), f.y);
}


float mod289(float x) { return x - floor(x * (1.0 / 289.0)) * 289.0;}
vec2 mod289(vec2 x) { return x - floor(x * (1.0 / 289.0)) * 289.0;}
vec3 mod289(vec3 x) { return x - floor(x * (1.0 / 289.0)) * 289.0;}
vec4 mod289(vec4 x) { return x - floor(x * (1.0 / 289.0)) * 289.0;}

float permute(float x) { return mod289(((x * 34.0) + 1.0) * x);}
vec2 permute(vec2 x) { return mod289(((x * 34.0) + 1.0) * x);}
vec3 permute(vec3 x) { return mod289(((x * 34.0) + 1.0) * x);}
vec4 permute(vec4 x) { return mod289(((x * 34.0) + 1.0) * x);}

/*============================== SimplexNoise ==============================*/
//### 2D
float snoise(vec2 v) {
  vec4 C   = vec4(0.211324865405187, 0.366025403784439, -0.577350269189626, 0.024390243902439);
  vec2 i   = floor(v + dot(v, C.yy));
  vec2 x0  = v - i + dot(i, C.xx);
  vec2 i1  = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;
  i      = mod289(i);  // Avoid truncation effects in permutation
  vec3 p = permute(permute(i.y + vec3(0.0, i1.y, 1.0)) + i.x + vec3(0.0, i1.x, 1.0));

  vec3 m  = max(0.5 - vec3(dot(x0, x0), dot(x12.xy, x12.xy), dot(x12.zw, x12.zw)), 0.0);
  m       = m * m;
  m       = m * m;
  vec3 x  = 2.0 * fract(p * C.www) - 1.0;
  vec3 h  = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;
  m *= 1.79284291400159 - 0.85373472095314 * (a0 * a0 + h * h);
  vec3 g;
  g.x  = a0.x * x0.x + h.x * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}
float fbm(vec2 uv, int oct) {
  vec2  pos = uv;
  float amp = 1.0, val = 0.0;
  for (int i = 0; i < oct; i++) {
    val += amp * snoise(pos);
    pos *= 2.0;
    amp *= 0.5;
  }
  return val;
}

//### 3D
float snoise(vec3 v) {
  vec2 C   = vec2(1.0 / 6.0, 1.0 / 3.0);
  vec4 D   = vec4(0.0, 0.5, 1.0, 2.0);
  vec3 i   = floor(v + dot(v, C.yyy));
  vec3 x0  = v - i + dot(i, C.xxx);
  vec3 g   = step(x0.yzx, x0.xyz);
  vec3 l   = 1.0 - g;
  vec3 i1  = min(g.xyz, l.zxy),i2  = max(g.xyz, l.zxy);
  vec3 x1  = x0 - i1 + C.xxx, x2  = x0 - i2 + C.yyy, x3  = x0 - D.yyy;
  i        = mod289(i);
  vec4  p  = permute(permute(permute(i.z + vec4(0.0, i1.z, i2.z, 1.0)) + i.y + vec4(0.0, i1.y, i2.y, 1.0)) + i.x + vec4(0.0, i1.x, i2.x, 1.0));
  float n_ = 0.142857142857;
  vec3  ns = n_ * D.wyz - D.xzx;
  vec4  j  = p - 49.0 * floor(p * ns.z * ns.z);
  vec4  x_ = floor(j * ns.z);
  vec4  y_ = floor(j - 7.0 * x_);
  vec4  x  = x_ * ns.x + ns.yyyy;
  vec4  y  = y_ * ns.x + ns.yyyy;
  vec4  h  = 1.0 - abs(x) - abs(y);
  vec4  b0 = vec4( x.xy, y.xy );
  vec4  b1 = vec4( x.zw, y.zw );
  vec4  s0 = floor(b0) * 2.0 + 1.0, s1 = floor(b1) * 2.0 + 1.0;
  vec4  sh = -step(h, vec4(0, 0, 0, 0));
  vec4  a0 = b0.xzyw + s0.xzyw * sh.xxyy, a1 = b1.xzyw + s1.xzyw * sh.zzww;
  vec3  p0 = vec3(a0.xy, h.x), p1 = vec3(a0.zw, h.y), p2 = vec3(a1.xy, h.z), p3 = vec3(a1.zw, h.w);
  //Normalise gradients
  vec4 norm = 1.79284291400159 - 0.85373472095314 * vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;
  // Mix final noise value
  vec4 m = max(0.6 - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), 0.0);
  m      = m * m;
  return 42.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}
float fbm(vec2 uv, int oct, float time) {
  vec2  pos = uv;
  float amp = 1.0;
  float val = 0.0;
  for (int i = 0; i < oct; i++) {
    val += amp * snoise(vec3(pos, time));
    pos *= 2.0;
    amp *= 0.5;
  }
  return val;
}


/*============================== hash ==============================*/
float hash11(float p) {
  p = fract(p * .1031);
  p *= p + 33.33;
  p *= p + p;
  return fract(p);
}
float hash12(vec2 p) {
  vec3 p3 = fract(vec3(p.xyx) * .1031);
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.x + p3.y) * p3.z);
}
float hash13(vec3 p3) {
  p3 = fract(p3 * .1031);
  p3 += dot(p3, p3.zyx + 31.32);
  return fract((p3.x + p3.y) * p3.z);
}
vec2 hash21(float p) {
  vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.xx + p3.yz) * p3.zy);
}
vec2 hash22(vec2 p) {
  vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.xx + p3.yz) * p3.zy);
}
vec2 hash23(vec3 p3) {
  p3 = fract(p3 * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.xx + p3.yz) * p3.zy);
}
vec3 hash31(float p) {
  vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.xxy + p3.yzz) * p3.zyx);
}
vec3 hash32(vec2 p) {
  vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yxz + 33.33);
  return fract((p3.xxy + p3.yzz) * p3.zyx);
}
vec3 hash33(vec3 p3) {
  p3 = fract(p3 * vec3(.1031, .1030, .0973));
  p3 += dot(p3, p3.yxz + 33.33);
  return fract((p3.xxy + p3.yxx) * p3.zyx);
}
vec4 hash41(float p) {
  vec4 p4 = fract(vec4(p) * vec4(.1031, .1030, .0973, .1099));
  p4 += dot(p4, p4.wzxy + 33.33);
  return fract((p4.xxyz + p4.yzzw) * p4.zywx);
}
vec4 hash42(vec2 p) {
  vec4 p4 = fract(vec4(p.xyxy) * vec4(.1031, .1030, .0973, .1099));
  p4 += dot(p4, p4.wzxy + 33.33);
  return fract((p4.xxyz + p4.yzzw) * p4.zywx);
}
vec4 hash43(vec3 p) {
  vec4 p4 = fract(vec4(p.xyzx) * vec4(.1031, .1030, .0973, .1099));
  p4 += dot(p4, p4.wzxy + 33.33);
  return fract((p4.xxyz + p4.yzzw) * p4.zywx);
}
vec4 hash44(vec4 p4) {
  p4 = fract(p4 * vec4(.1031, .1030, .0973, .1099));
  p4 += dot(p4, p4.wzxy + 33.33);
  return fract((p4.xxyz + p4.yzzw) * p4.zywx);
}
const float digi =.1;

float calcHeight(vec2 uv){
    int id = int(floor(uv.x/digi) + floor(uv.y/digi)*iResolution.x);
    float rnd =random(float(id));
    float s = mix(15.,100., rnd);
    vec2  v = hash21(rnd*10.);
    float a = floor(rnd*8.)*45.;
    uv *=  mat2(cos(a),-sin(a), sin(a),cos(a));
    return fbm(uv *s *v, 5, rnd) * .005;
}

vec3 calcNormal(vec2 uv){
    float d = 0.0001;
    float l0 = calcHeight(uv);
    float l1 = calcHeight(uv + vec2(d, 0.0));
    float l2 = calcHeight(uv + vec2(0.0, d));
    return normalize(vec3(-(l1 - l0), -(l2 - l0), d));
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (2.0*fragCoord-iResolution.xy) / min(iResolution.x, iResolution.y);
    //fragColor = vec4(uv,0.,1.); return;
    
    vec3 lightPos;
#ifdef AUTO_LIGHT
    float t = iTime * 2.;
    lightPos = vec3(cos(t) * 1.5 + 0.5, sin(t) * 0.5 + 0.5, 1.0);
#else
    vec2 mp = (2.0*iMouse.xy-iResolution.xy) / min(iResolution.x, iResolution.y);
    lightPos = vec3(mp, 1.5);
    //fragColor = vec4(smoothstep(.2,.1, distance(uv,mp))); return;
#endif
    
    //float height = calcHeight(uv);
    //fragColor = vec4(height); return;
    vec3 normal = calcNormal(uv);
    //fragColor = vec4(normal, 1.); return;
    
    //--- phong
    vec3 lightDir = normalize(vec3(lightPos - vec3(uv, 0.0)));
    float diffuse = max(0.0, dot(normal, lightDir));
    vec3 vReflection = normalize(reflect(-lightDir, normal));
    float specular = pow(max(0.0, dot(normal, vReflection)), 5.0);
    vec3 ambientColor = vec3(0.01);
    vec3 diffuseColor;
#ifdef RANDOM_COLOR
    int id = int(floor(uv.x/digi) + floor(uv.y/digi)*iResolution.x);
    diffuseColor = hash31(float(id));
#else
    vec2 digiUV = floor(fragCoord.xy/iResolution.xy / digi) * digi;
    diffuseColor = texture(iChannel0, digiUV).rgb;
    diffuseColor = texture(iChannel0, fragCoord.xy/iResolution.xy).rgb;
#endif
    //fragColor = vec4(diffuseColor , 1.0); return;
    vec3 col = min(vec3(1.0), ambientColor + diffuseColor * diffuse + specular);
    
    
    vec2 tileUV = mod(uv,digi) / digi;
    float frame  = smoothstep(.3,.45,pow(sin(tileUV.x*3.1415), .75));
          frame *= smoothstep(.3,.45,pow(sin(tileUV.y*3.1415), .75));
          frame  = smoothstep(.4,.45,frame);
    col *= frame;

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

